/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RSConfig {
    private final Configuration config;
    private final RSConfig originalClientVersion;
    public int controllerBaseUsage;
    public int controllerMaxReceive;
    public int cableUsage;
    public int constructorUsage;
    public int crafterUsage;
    public int crafterPerPatternUsage;
    public int craftingMonitorUsage;
    public int crafterManagerUsage;
    public int destructorUsage;
    public int detectorUsage;
    public int diskDriveUsage;
    public int diskDrivePerDiskUsage;
    public int externalStorageUsage;
    public int externalStoragePerStorageUsage;
    public int exporterUsage;
    public int importerUsage;
    public int interfaceUsage;
    public int fluidInterfaceUsage;
    public int relayUsage;
    public int storageUsage;
    public int fluidStorageUsage;
    public int wirelessTransmitterUsage;
    public int gridUsage;
    public int craftingGridUsage;
    public int patternGridUsage;
    public int fluidGridUsage;
    public int networkTransmitterUsage;
    public int networkReceiverUsage;
    public int diskManipulatorUsage;
    public int securityManagerUsage;
    public int securityManagerPerSecurityCardUsage;
    public int controllerCapacity;
    public boolean controllerUsesEnergy;
    public int maxRowsStretch;
    public boolean largeFont;
    public boolean detailedTooltip;
    public int wirelessTransmitterBaseRange;
    public int wirelessTransmitterRangePerUpgrade;
    public boolean wirelessGridUsesEnergy;
    public int wirelessGridCapacity;
    public int wirelessGridOpenUsage;
    public int wirelessGridExtractUsage;
    public int wirelessGridInsertUsage;
    public boolean wirelessCraftingGridUsesEnergy;
    public int wirelessCraftingGridCraftUsage;
    public int wirelessCraftingGridOpenUsage;
    public boolean portableGridUsesEnergy;
    public int portableGridCapacity;
    public int portableGridOpenUsage;
    public int portableGridExtractUsage;
    public int portableGridInsertUsage;
    public boolean wirelessFluidGridUsesEnergy;
    public int wirelessFluidGridCapacity;
    public int wirelessFluidGridOpenUsage;
    public int wirelessFluidGridExtractUsage;
    public int wirelessFluidGridInsertUsage;
    public boolean wirelessCraftingMonitorUsesEnergy;
    public int wirelessCraftingMonitorCapacity;
    public int wirelessCraftingMonitorOpenUsage;
    public int wirelessCraftingMonitorCancelUsage;
    public int wirelessCraftingMonitorCancelAllUsage;
    public int rangeUpgradeUsage;
    public int speedUpgradeUsage;
    public int craftingUpgradeUsage;
    public int stackUpgradeUsage;
    public int silkTouchUpgradeUsage;
    public int fortuneUpgradeUsagePerFortune;
    public int regulatorUpgradeUsage;
    public int readerUsage;
    public int writerUsage;
    public int readerWriterChannelEnergyCapacity;
    public boolean hideCovers;
    public int calculationTimeoutMs;
    private static final String ENERGY = "energy";
    private static final String CONTROLLER = "controller";
    private static final String GRID = "grid";
    private static final String WIRELESS_TRANSMITTER = "wirelessTransmitter";
    private static final String WIRELESS_GRID = "wirelessGrid";
    private static final String WIRELESS_CRAFTING_GRID = "wirelessCraftingGrid";
    private static final String PORTABLE_GRID = "portableGrid";
    private static final String WIRELESS_FLUID_GRID = "wirelessFluidGrid";
    private static final String WIRELESS_CRAFTING_MONITOR = "wirelessCraftingMonitor";
    private static final String UPGRADES = "upgrades";
    private static final String READER_WRITER = "readerWriter";
    private static final String COVERS = "covers";
    private static final String AUTOCRAFTING = "autocrafting";
    private static final String MISC = "misc";

    public RSConfig(@Nullable RSConfig originalClientVersion, File configFile) {
        this(originalClientVersion, new Configuration(configFile));
    }

    public RSConfig(@Nullable RSConfig originalClientVersion, Configuration config) {
        this.originalClientVersion = originalClientVersion;
        this.config = config;
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.loadConfig();
    }

    public Configuration getConfig() {
        return this.config;
    }

    @Nullable
    public RSConfig getOriginalClientVersion() {
        return this.originalClientVersion;
    }

    @SubscribeEvent
    public void onConfigChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equalsIgnoreCase("refinedstorage")) {
            this.loadConfig();
        }
    }

    private void loadConfig() {
        this.controllerBaseUsage = this.config.getInt("controllerBase", ENERGY, 0, 0, Integer.MAX_VALUE, "The base energy used by the Controller");
        this.controllerMaxReceive = this.config.getInt("controllerMaxReceive", ENERGY, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, "The maximum energy the controller receives per tick");
        this.cableUsage = this.config.getInt("cable", ENERGY, 0, 0, Integer.MAX_VALUE, "The energy used by Cables");
        this.constructorUsage = this.config.getInt("constructor", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Constructors");
        this.crafterUsage = this.config.getInt("crafter", ENERGY, 2, 1, Integer.MAX_VALUE, "The base energy used by Crafters");
        this.crafterPerPatternUsage = this.config.getInt("crafterPerPattern", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used per Pattern in a Crafter");
        this.craftingMonitorUsage = this.config.getInt("craftingMonitor", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Crafting Monitors");
        this.crafterManagerUsage = this.config.getInt("crafterManager", ENERGY, 4, 0, Integer.MAX_VALUE, "The energy used by Crafter Managers");
        this.destructorUsage = this.config.getInt("destructor", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Destructors");
        this.detectorUsage = this.config.getInt("detector", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Detectors");
        this.diskDriveUsage = this.config.getInt("diskDrive", ENERGY, 5, 1, Integer.MAX_VALUE, "The base energy used by Disk Drives");
        this.diskDrivePerDiskUsage = this.config.getInt("diskDrivePerDisk", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used by Storage Disks in Disk Drives");
        this.externalStorageUsage = this.config.getInt("externalStorage", ENERGY, 1, 1, Integer.MAX_VALUE, "The base energy used by External Storages");
        this.externalStoragePerStorageUsage = this.config.getInt("externalStoragePerStorage", ENERGY, 1, 0, Integer.MAX_VALUE, "The additional energy used per connected storage to an External Storage");
        this.exporterUsage = this.config.getInt("exporter", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Exporters");
        this.importerUsage = this.config.getInt("importer", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Importers");
        this.interfaceUsage = this.config.getInt("interface", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Interfaces");
        this.fluidInterfaceUsage = this.config.getInt("fluidInterface", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Fluid Interfaces");
        this.relayUsage = this.config.getInt("relay", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Relays");
        this.storageUsage = this.config.getInt("storage", ENERGY, 1, 1, Integer.MAX_VALUE, "The energy used by Storage Blocks");
        this.fluidStorageUsage = this.config.getInt("fluidStorage", ENERGY, 1, 0, Integer.MAX_VALUE, "The energy used by Fluid Storage Blocks");
        this.wirelessTransmitterUsage = this.config.getInt(WIRELESS_TRANSMITTER, ENERGY, 8, 1, Integer.MAX_VALUE, "The energy used by Wireless Transmitters");
        this.gridUsage = this.config.getInt(GRID, ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Grids");
        this.craftingGridUsage = this.config.getInt("craftingGrid", ENERGY, 4, 0, Integer.MAX_VALUE, "The energy used by Crafting Grids");
        this.patternGridUsage = this.config.getInt("patternGrid", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Pattern Grids");
        this.fluidGridUsage = this.config.getInt("fluidGrid", ENERGY, 2, 0, Integer.MAX_VALUE, "The energy used by Fluid Grids");
        this.networkTransmitterUsage = this.config.getInt("networkTransmitter", ENERGY, 64, 0, Integer.MAX_VALUE, "The energy used by Network Transmitters");
        this.networkReceiverUsage = this.config.getInt("networkReceiver", ENERGY, 1, 1, Integer.MAX_VALUE, "The energy used by Network Receivers");
        this.diskManipulatorUsage = this.config.getInt("diskManipulator", ENERGY, 3, 0, Integer.MAX_VALUE, "The energy used by Disk Manipulators");
        this.securityManagerUsage = this.config.getInt("securityManager", ENERGY, 4, 1, Integer.MAX_VALUE, "The base energy used by Security Managers");
        this.securityManagerPerSecurityCardUsage = this.config.getInt("securityManagerPerSecurityCard", ENERGY, 10, 0, Integer.MAX_VALUE, "The additional energy used by Security Cards in Security Managers");
        this.controllerCapacity = this.config.getInt("capacity", CONTROLLER, 32000, 0, Integer.MAX_VALUE, "The energy capacity of the Controller");
        this.controllerUsesEnergy = this.config.getBoolean("usesEnergy", CONTROLLER, true, "Whether the Controller uses energy");
        this.maxRowsStretch = this.config.getInt("maxRowsStretch", GRID, Integer.MAX_VALUE, 3, Integer.MAX_VALUE, "The maximum amount of rows that the Grid can show when stretched");
        this.largeFont = this.config.getBoolean("largeFont", GRID, false, "Whether the Grid should use a large font for stack quantity display");
        this.detailedTooltip = this.config.getBoolean("detailedTooltip", GRID, true, "Whether the Grid should display a detailed tooltip when hovering over an item or fluid");
        this.wirelessTransmitterBaseRange = this.config.getInt("range", WIRELESS_TRANSMITTER, 16, 0, Integer.MAX_VALUE, "The base range of the Wireless Transmitter");
        this.wirelessTransmitterRangePerUpgrade = this.config.getInt("rangePerUpgrade", WIRELESS_TRANSMITTER, 8, 0, Integer.MAX_VALUE, "The additional range per Range Upgrade in the Wireless Transmitter");
        this.wirelessGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_GRID, true, "Whether the Wireless Grid uses energy");
        this.wirelessGridCapacity = this.config.getInt("capacity", WIRELESS_GRID, 3200, 0, Integer.MAX_VALUE, "The energy capacity of the Wireless Grid");
        this.wirelessGridOpenUsage = this.config.getInt("open", WIRELESS_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to open");
        this.wirelessGridInsertUsage = this.config.getInt("insert", WIRELESS_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to insert items");
        this.wirelessGridExtractUsage = this.config.getInt("extract", WIRELESS_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Grid to extract items");
        this.wirelessCraftingGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_CRAFTING_GRID, true, "Whether the Wireless Crafting Grid uses energy");
        this.wirelessCraftingGridCraftUsage = this.config.getInt("craft", WIRELESS_CRAFTING_GRID, 1, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid when crafting");
        this.wirelessCraftingGridOpenUsage = this.config.getInt("open", WIRELESS_CRAFTING_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Grid to open");
        this.portableGridUsesEnergy = this.config.getBoolean("usesEnergy", PORTABLE_GRID, true, "Whether the Portable Grid uses energy");
        this.portableGridCapacity = this.config.getInt("capacity", PORTABLE_GRID, 3200, 0, Integer.MAX_VALUE, "The energy capacity of the Portable Grid");
        this.portableGridOpenUsage = this.config.getInt("open", PORTABLE_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Portable Grid to open");
        this.portableGridInsertUsage = this.config.getInt("insert", PORTABLE_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Portable Grid to insert items");
        this.portableGridExtractUsage = this.config.getInt("extract", PORTABLE_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Portable Grid to extract items");
        this.wirelessFluidGridUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_FLUID_GRID, true, "Whether the Fluid Wireless Grid uses energy");
        this.wirelessFluidGridCapacity = this.config.getInt("capacity", WIRELESS_FLUID_GRID, 3200, 0, Integer.MAX_VALUE, "The energy capacity of the Wireless Fluid Grid");
        this.wirelessFluidGridOpenUsage = this.config.getInt("open", WIRELESS_FLUID_GRID, 30, 0, Integer.MAX_VALUE, "The energy used by the Fluid Wireless Grid to open");
        this.wirelessFluidGridInsertUsage = this.config.getInt("insert", WIRELESS_FLUID_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Fluid Grid to insert items");
        this.wirelessFluidGridExtractUsage = this.config.getInt("extract", WIRELESS_FLUID_GRID, 3, 0, Integer.MAX_VALUE, "The energy used by the Wireless Fluid Grid to extract items");
        this.wirelessCraftingMonitorUsesEnergy = this.config.getBoolean("usesEnergy", WIRELESS_CRAFTING_MONITOR, true, "Whether the Wireless Crafting Monitor uses energy");
        this.wirelessCraftingMonitorCapacity = this.config.getInt("capacity", WIRELESS_CRAFTING_MONITOR, 3200, 0, Integer.MAX_VALUE, "The energy capacity of the Wireless Crafting Monitor");
        this.wirelessCraftingMonitorOpenUsage = this.config.getInt("open", WIRELESS_CRAFTING_MONITOR, 35, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to open");
        this.wirelessCraftingMonitorCancelUsage = this.config.getInt("cancel", WIRELESS_CRAFTING_MONITOR, 4, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to cancel a task");
        this.wirelessCraftingMonitorCancelAllUsage = this.config.getInt("cancelAll", WIRELESS_CRAFTING_MONITOR, 5, 0, Integer.MAX_VALUE, "The energy used by the Wireless Crafting Monitor to cancel all tasks");
        this.rangeUpgradeUsage = this.config.getInt("range", UPGRADES, 8, 0, Integer.MAX_VALUE, "The additional energy used per Range Upgrade");
        this.speedUpgradeUsage = this.config.getInt("speed", UPGRADES, 2, 0, Integer.MAX_VALUE, "The additional energy used per Speed Upgrade");
        this.craftingUpgradeUsage = this.config.getInt("crafting", UPGRADES, 5, 0, Integer.MAX_VALUE, "The additional energy used per Crafting Upgrade");
        this.stackUpgradeUsage = this.config.getInt("stack", UPGRADES, 12, 0, Integer.MAX_VALUE, "The additional energy used per Stack Upgrade");
        this.silkTouchUpgradeUsage = this.config.getInt("silkTouch", UPGRADES, 15, 0, Integer.MAX_VALUE, "The additional energy used by the Silk Touch Upgrade");
        this.fortuneUpgradeUsagePerFortune = this.config.getInt("fortune", UPGRADES, 10, 0, Integer.MAX_VALUE, "The additional energy used by the Fortune Upgrade, multiplied by the level of the enchantment");
        this.regulatorUpgradeUsage = this.config.getInt("regulator", UPGRADES, 15, 0, Integer.MAX_VALUE, "The additional energy used by the Regulator Upgrade");
        this.readerUsage = this.config.getInt("reader", READER_WRITER, 2, 0, Integer.MAX_VALUE, "The energy used by Readers");
        this.writerUsage = this.config.getInt("writer", READER_WRITER, 2, 0, Integer.MAX_VALUE, "The energy used by Writers");
        this.readerWriterChannelEnergyCapacity = this.config.getInt("channelEnergyCapacity", READER_WRITER, 16000, 0, Integer.MAX_VALUE, "The energy capacity of energy channels");
        this.hideCovers = this.config.getBoolean("hideCovers", COVERS, false, "Whether to hide covers in the creative mode tabs and JEI");
        this.calculationTimeoutMs = this.config.getInt("calculationTimeoutMs", AUTOCRAFTING, 5000, 5000, Integer.MAX_VALUE, "The autocrafting calculation timeout in milliseconds, tasks taking longer than this to calculate (NOT execute) are cancelled to avoid server strain");
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> list = new ArrayList<IConfigElement>();
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(ENERGY)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(CONTROLLER)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(UPGRADES)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(WIRELESS_TRANSMITTER)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(GRID)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(WIRELESS_GRID)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(WIRELESS_FLUID_GRID)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(WIRELESS_CRAFTING_MONITOR)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(PORTABLE_GRID)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(READER_WRITER)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(COVERS)));
        list.add((IConfigElement)new ConfigElement(this.config.getCategory(AUTOCRAFTING)));
        return list;
    }
}

